# BEGIN SourceDeps(oneline):
BuildRequires(pre): /usr/bin/sox perl(Compress/Zlib.pm) perl(IO/CaptureOutput.pm) perl(Module/Build.pm) perl(Module/Build/Compat.pm) perl(Test/More.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Audio-Extract-PCM
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Extract PCM data from audio files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PE/PEPE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module's purpose is to extract PCM data from various audio formats.  PCM
is the format in which you send data to your sound card driver.  This module
aims to provide a single interface for PCM extraction from various audio
formats, compressed and otherwise.

Currently the implementation makes use of the external "sox" program.  As of
2008, sox's supported input formats include "wav", "mp3", "ogg/vorbis", "flac",
if you have compiled sox with support for them, but do not include "wma" or
"aac".

I have chosen the use of "sox" for the first implementation of this module
because it already has an abstract interface to many formats.  However I plan
to include more implementations to (1) maybe include more formats, (2) make the
implementation more perlish and (3) make the module more portable.  CPAN has
specialized modules like the Audio::Mad manpage and the Ogg::Vorbis::Decoder manpage, to which I
could implement an abstract interface.

If you have suggestions how to include more implementations, or if you simply
need them and want to motivate me, please contact me.

Usage example:

    use Audio::PCM::Extract;
    my $extractor = Audio::PCM::Extract->new('song.ogg');
    my $pcm = $extractor->pcm(44100, 2, 2) or die $extractor->error;


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes example
%perl_vendor_privlib/A*

%changelog
