%define module_version 0.002001
%define module_name Audio-LibSampleRate
# BEGIN SourceDeps(oneline):
BuildRequires: libalsa-devel libfftw3-devel libsamplerate-devel libsndfile-devel libsowing-devel perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(XSLoader.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002001
Release: alt6
Summary: interface to Secret Rabbit Code audio sample rate converter
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{module_version}.tar.gz

%description
Secret Rabbit Code (aka libsamplerate) is a Sample Rate Converter for
audio. One example of where such a thing would be useful is converting
audio from the CD sample rate of 44.1kHz to the 48kHz sample rate used
by DAT players.

SRC is capable of arbitrary and time varying conversions ; from
downsampling by a factor of 256 to upsampling by the same factor.
Arbitrary in this case means that the ratio of input and output sample
rates can be an irrational number. The conversion ratio can also vary
with time for speeding up and slowing down effects.

SRC provides a small set of converters to allow quality to be traded
off against computation cost. The current best converter provides a
signal-to-noise ratio of 145dB with -3dB passband extending from DC to
96%% of the theoretical best bandwidth for a given pair of input and
output sample rates.

There are two interfaces: a simple procedural interface which converts
a single block of samples in one go, and a more complex object
oriented interface which can handle streaming data, for situations
where the data is received in small pieces.

The underlying library also defines a callback interface, which is not
yet implemented in Audio::LibSampleRate.

All functions and methods below die in case of error with a message
containing the error number and description, as returned by SRC.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes libsamplerate/COPYING
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
