# BEGIN SourceDeps(oneline):
BuildRequires: perl(Apache/Htgroup.pm) perl(Apache/Htpasswd.pm) perl(Class/Data/Inheritable.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Authen-Class-HtAuth
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: class-based authentication backend using Apache user
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RY/RYANM/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Authen::Class::HtAuth is an authentication backend for use with Apache passwd
and group files.  Authen::Class::HtAuth can be instantiated as an object or
inherited into your own class.

Class-based example:

  package MyAuth;
  use base 'Authen::Class::HtAuth';

  MyAuth->htusers("/path/to/users");
  MyAuth->htgroups("/path/to/groups"); # optional

# elsewhere...
  
  use MyAuth;
  if (MyAuth->check("user", "pass", groups => ["foo"]))  # groups is optional
  { ... }

Object example:
  
  use Authen::Class::HtAuth;

  my $htauth = Authen::Class::HtAuth->new(
    htusers => "/path/to/users",   # optional
    htgroups => "/path/to/groups", # optional
  );

  # or you can load the user and group files after object creation

  $htauth->htusers("/path/to/users");
  $htauth->htgroups("/path/to/groups"); # optional

  if ($htauth->check(qw/user pass/, groups => ['foo'])) # groups is optional
  {
    ...
  }
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*

%changelog
