# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Authen-Htpasswd
%define upstream_version 0.171

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Interface to read and modify Apache .htpasswd files
License:    Artistic/GPL
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Authen/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Class/Accessor/Fast.pm)
BuildRequires: perl(Crypt/PasswdMD5.pm)
BuildRequires: perl(Digest.pm)
BuildRequires: perl(Digest/SHA1.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(IO/LockedFile.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildArch:  noarch
Source44: import.info

%description
This module provides a convenient, object-oriented interface to Apache-style
.htpasswd files. It supports passwords encrypted via MD5, SHA1, and crypt, as
well as plain (cleartext) passwords. It requires Crypt::PasswdMD5 for MD5 and
Digest::SHA1 for SHA1. 

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
make test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml README
%{perl_vendor_privlib}/Authen

%changelog
