Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Authen-Krb5
Version:        1.9
Release:        alt14_42
Summary:        Krb5 Perl module
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Krb5
Source0:        https://cpan.metacpan.org/authors/id/J/JH/JHORWITZ/Krb5-%{version}.tar.gz
# Do not link functions removed from krb5, bug #1323662, CPAN RT#116071
Patch0:         Krb5-1.9-nopriv.patch
BuildRequires:  gcc
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  libkrb5-devel
BuildRequires:  perl-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  sed
Source44: import.info

%description
Authen::Krb5 is an object oriented interface to the Kerberos 5 API. Both
the implementation and documentation are nowhere near complete, and may
require previous experience with Kerberos 5 programming. Most of the
functions here are documented in detail in the Kerberos 5 API
documentation.

%prep
%setup -q -n Krb5-%{version}
%patch0 -p1

# Rewrite the Makefile with our local paths
sed -e's|/usr/lib|%{_libdir}|' \
    -e's|/usr/include|%{_includedir}|' \
    -i  Makefile.PL

# Fix the references to /usr/local/bin/perl
sed -i 's|/usr/local/bin/perl|/usr/bin/perl|' \
  sample_client sample_server simple_client simple_server

%build
# Build in C89 mode because this package uses internal krb5 functions
# without prototypes in <krb5.h>.
%global build_type_safety_c 0
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}"
%make_build

%install

make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} $RPM_BUILD_ROOT
chmod 644 sample_client sample_server simple_client simple_server

%check
make test

%files
%doc Changes COPYRIGHT README sample_client sample_server simple_client simple_server TODO
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/Authen

%changelog
