Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Signature.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: libkrb5-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Authen-Krb5-Admin
Version:        0.17
Release:        alt14_36
Summary:        Perl extension for MIT Kerberos 5 admin interface
# admin.h - MIT
# ppport.h - GPL+ or Artisic (same as any version of Perl)
# everything else: BSD (two clause)
License:        MIT and BSD and (GPL+ or Artistic)
URL:            https://metacpan.org/release/Authen-Krb5-Admin
Source0:        https://cpan.metacpan.org/authors/id/S/SJ/SJQUINNEY/Authen-Krb5-Admin-%{version}.tar.gz
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  libkrb5-devel
BuildRequires:  libssl-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Authen/Krb5.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  sed
# Run-time - not used during build
#BuildRequires:  perl(AutoLoader)
#BuildRequires:  perl(Carp)
#BuildRequires:  perl(DynaLoader)
#BuildRequires:  perl(Exporter)
#BuildRequires:  perl(vars)
# Tests - tests are not executed
#BuildRequires:  perl(Socket)
#BuildRequires:  perl(Test)


Source44: import.info

%description
Authen::Krb5::Admin is an object-oriented interface to the Kerberos 5 admin
server. Currently only MIT KDCs are supported, but the author envisions
seamless integration with other KDCs.

%prep
%setup -q -n Authen-Krb5-Admin-%{version}

sed -i -e 's!$PREFIX/lib!$PREFIX/%{_lib}!' Makefile.PL
# alt krb5
if [ ! -e /usr/include/krb5.h ]; then
	sed -i -e 's,krb5\.h,krb5/krb5.h,' Makefile.PL Admin.xs
fi

%build
# set some dummy values for the test to stop Makefile.PL from asking
# note: the values are never used
export PERL_KADM5_PRINCIPAL=dummy
export PERL_KADM5_TEST_NAME=dummy
export PERL_KADM5_TEST_NAME_2=dummy
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -delete
# %{_fixperms} $RPM_BUILD_ROOT/*


%files
%doc README COPYING ChangeLog
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/Authen


%changelog
