# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(CPAN.pm) perl(Config.pm) perl(Crypt/DES.pm) perl(Crypt/DES_PP.pm) perl(Cwd.pm) perl(Digest/MD4.pm) perl(Digest/Perl/MD4.pm) perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.33
%define module_name Authen-NTLM-HTTP
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.33
Release: alt1
Summary: Perl extension for NTLM-over-HTTP related computations
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BO/BOBTFISH/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use Authen::NTLM (nt_hash lm_hash);
use Authen::NTLM::HTTP;

    $my_pass = "mypassword";
# Note: To instantiate a client talking to a proxy, do
# $client = new_client Authen::NTLM::HTTP(lm_hash($my_pass), nt_hash($my_pass), Authen::NTLM::HTTP::NTLMSSP_HTTP_PROXY);
    $client = new_client Authen::NTLM::HTTP(lm_hash($my_pass), nt_hash($my_pass));

# Stage 3 scenario: creates NTLM negotiate message and then
# append $negotiate_msg to one of the tag lines in your HTTP
# request header

# To compose a NTLM Negotiate Packet
    $flags = Authen::NTLM::NTLMSSP_NEGOTIATE_ALWAYS_SIGN
_   | Authen::NTLM::NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED
_   | Authen::NTLM::NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED
_   | Authen::NTLM::NTLMSSP_NEGOTIATE_NTLM
_   | Authen::NTLM::NTLMSSP_NEGOTIATE_UNICODE
_   | Authen::NTLM::NTLMSSP_NEGOTIATE_OEM
    $negotiate_msg = $client->http_negotiate($flags);

# Stage 4 scenario: extract the line contains "Authorization: NTLM "
# in the HTTP header.
# Parses NTLM negotiate message and then generates
# the NTLM challenge message.

# To instantiate a server to parse a NTLM negotiation
# and compose a NTLM challenge
# Note: To instantiate a proxy, do
# $server = new_server Authen::NTLM::HTTP(Authen::NTLM::HTTP::NTLMSSP_HTTP_PROXY);
    $server = new_server Authen::NTLM::HTTP;

    ($flags, $domain, $machine) =
_$server->http_parse_negotiate($negotiate_msg);

    $flags = Authen::NTLM::NTLMSSP_NEGOTIATE_ALWAYS_SIGN
_   | Authen::NTLM::NTLMSSP_NEGOTIATE_NTLM
_   | Authen::NTLM::NTLMSSP_NEGOTIATE_UNICODE;
    $challenge_msg = $server->http_challenge($flags);

# Stage 5 Scenario: Client receives NTLM challenge message
# Extract the line that contains "WWW-Authenticate: NTLM "
# Pass it to http_parse_challenge to obtain the nonce
# Then use nonce to compose reply with http_auth

# client parse NTLM challenge
    ($domain, $flags, $nonce, $ctx_upper, $ctx_lower) =
_$client->http_parse_challenge($challenge_msg);

# To compose a NTLM Response Packet
    $flags = Authen::NTLM::NTLMSSP_NEGOTIATE_ALWAYS_SIGN
_   | Authen::NTLM::NTLMSSP_NEGOTIATE_NTLM
_   | Authen::NTLM::NTLMSSP_NEGOTIATE_UNICODE
_   | Authen::NTLM::NTLMSSP_REQUEST_TARGET;
    $auth_msg = $client->http_auth($nonce, $flags);

# Stage 6 Scenario: Finally the server parses the reply
# verify the authentication credentials.

# To parse a NTLM Response Packet
    ($flags, $lm_resp, $nt_resp, $user_domain, $username, $machine) =
_$server->http_parse_auth($auth_msg);


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/A*

%changelog
