%define module_name Authen-TacacsPlus
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Digest/MD5.pm) perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.28
Release: alt4
Summary: Perl extension for authentication using tacacs+ server
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MI/MIKEM/%{module_name}-%{version}.tar.gz

%description
Authen::TacacsPlus allows you to authenticate using tacacs+ server.

  $tac = new Authen::TacacsPlus(Host=>$server,      
 _                Key=>$key,          
                        [Port=>'tacacs'],   
                        [Timeout=>15]);     

Opens new session with tacacs+ server on host $server, encrypted
with key $key. Undefined object is returned if something wrong
(check errmsg()).

With a list of servers the order is relevant. It checks the availability
of the Tacacs+ service using the order you defined.


  Authen::TacacsPlus::errmsg();

Returns last error message.  

  $tac->authen($username,$password,$authen_type);

Tries an authentication with $username and $password. 1 is returned if
authenticaton succeded and 0 if failed (check errmsg() for reason).

$authen_type is an optional argument that specifies what type
of authentication to perform. Allowable options are:
Authen::TacacsPlus::TAC_PLUS_AUTHEN_TYPE_ASCII (default)
Authen::TacacsPlus::TAC_PLUS_AUTHEN_TYPE_PAP
Authen::TacacsPlus::TAC_PLUS_AUTHEN_TYPE_CHAP

ASCII uses Tacacs+ version 0, and will authenticate against 
the "login" or "global" password on the Tacacs+ server. If no
authen_type is specified, it defaults to this type of authentication.

PAP uses Tacacs+ version 1, and will authenticate against 
the "pap" or "global" password on the Tacacs+ server.

CHAP uses Tacacs+ version 1, and will authenticate against 
the "chap" or "global" password on the Tacacs+ server. With CHAP,
the password if formed by the concatenation of
  chap id + chap challenge + chap response

There is example code in test.pl

If you use a list of servers you can continue using $tac->authen if
one of them goes down or become unreachable.


  $tac->close();

Closes session with tacacs+ server.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
