# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Test/More.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define module_name Author-Daemon
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: daemon's helpful creations
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAEMON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A place to store my things!

Over the years I realized I was in the habbit of rewriting a lot of common
functionalities that on there own did not warrent a fully fledged module,
simply due to them requiring expansion of functionality, more git repositories,
more tests ... more work than just re-writing the snippets when they was
required. 

However, when I worked out just how much time I had likely wasted re-writing
loose odds and ends, I decided something must be done, but what?

Well after some thought I decided that I would slowly add all my little tidbits
into one singular module nicely packed in git with dzil with some form of
generic interface so it was easy to add other bits of code here and there with
no more cost than what it would cost me to once again re-write those snippets.

I could not see or find an actual reference to how a pause/perl user should
really go about such a thing while still keeping the ease of a published
module, there seems to be no particular Author who has ever done what I am
attempting (could be wrong though!); so after even more thought. I come to the
conclusion the ideal solution would be A namespace providing the previously
stated single interface that could not collide with fully fledged modules,
almost a 'users unreleased'. 

I found that Author::__PAUSEID__ seemed to hit the nail on the head, at the
time of writing is not reserved in anyway infact I could not see any modules
using the prefix at all. Though I am hoping one or two module authors like the
idea to hopefully push the idea forwards.

From what I can see, it is a benefit to everyone - the authors have a nice
public place to fetch their favorite play things and possible others will find
the odd 'never made a module but still a cool function' enough to develop them
further into actual modules.

Let me know how you feel if you do stumble over this module (either message me
on irc libera.org or perl.org nickname 'daemon' or drop me an issue against the
repository for this module on github)

=for comment The mod...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE
%perl_vendor_privlib/A*

%changelog
