%define module_name Automate-Animate-FFmpeg
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd/utf8.pm) perl(Data/Roundtrip.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Find/Rule.pm) perl(File/Replace.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(File/Which.pm) perl(FindBin.pm) perl(IPC/Run.pm) perl(Test/More.pm) perl(Test/Script.pm) perl(Test2/Plugin/UTF8.pm) perl(Text/ParseWords.pm) perl(Unicode/Normalize.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Create animation from a sequence of images using ffmpeg
Group: Development/Perl
License: artistic_2
URL: https://metacpan.org/module/Automate::Animate::FFmpeg

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLIAKO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module creates an animation from a sequence of input
images using FFmpeg.
An excellent, open source program.

    use Automate::Animate::FFmpeg;
    my $aaFFobj = Automate::Animate::FFmpeg->new({
      # specify input images in any of these 3 ways:
      'input-images' => [
        'im1.png',
        'im2.png',
        ...
      ],
      'input-pattern' => ['*.png', './'],
      'input-images-from-file' => 'file-containing-a-list-of-pathnames-to-images.txt',
      # optionally specify the duration of each frame
      'frame-duration' => 5.3, # seconds
      'output-filename' => 'out.mp4',
    });

    # options can be set after construction as well:

    # optionally add some extra params to FFmpeg as an arrayref
    $aaFF->ffmpeg_extra_params(['-x', 'abc', '-y', 1, 2, 3]);
    # you can also add images here, order is important
    $aaFF->input_images(['img1.png', 'img2.png']) or die;
    # or add images via a search pattern and optional search dir
    $aaFF->input_pattern(['*.png', './']);
    # or add images via multiple search patterns
    $aaFF->input_patterns([
_['*.png', './'],
_['*.jpg', '/images'],
_['*.tiff'], # this defaults to current dir
    ]) or die;

    # and make the animation:
    die "make_animation() has failed"
      unless $aaFF->make_animation()
    ;

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md
%perl_vendor_privlib/A*

%files scripts
%_bindir/*

%changelog
