%define module_name Badge-Simple
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Carp/Always.pm) perl(Data/Dump.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Glob.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(HTTP/Tiny.pm) perl(Imager.pm) perl(JSON/MaybeXS.pm) perl(Path/Class.pm) perl(Regexp/Common.pm) perl(Test/DistManifest.pm) perl(Test/MinimumVersion.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Text/CleanFragment.pm) perl(URI.pm) perl(XML/LibXML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Generate simple SVG badges
Group: Development/Perl
License: perl
URL: https://github.com/haukex/Badge-Simple

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HAUKEX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module generates simple badges, based heavily on the default
"flat" style of Shields.io.

The module currently exports a single function, `badge', which
returns an XML::LibXML::Document object
representing the SVG file. The function takes the following
arguments:

=over

=item `left'

Text on the left side of the badge. Required.

=item `right'

Text on the right side of the badge. Required.

=item `color'

Either an HTML hex color string (`"#AABBCC"'), or one of the
following predefined color schemes: `blue', `brightgreen',
`green', `lightgrey', `orange', `red', `yellow',
`yellowgreen'. If omitted, defaults to `lightgrey'.

=item `font'

The filename of a font file (as supported by
Imager::Font), for example you might point this at
your local copy of Verdana.ttf. This font is currently *only*
used to calculate the width of the badge. If omitted, defaults to
DejaVuSans.ttf, which is distributed with this module.

Note: Different font libraries may calculate the widths of fonts
slightly differently. This module's tests check to make sure that
these variations are not too large (within a couple of pixels), but
*be aware* that badges generated on different systems might have
slightly different widths.

=back

The return value of `badge', an
XML::LibXML::Document object, can easily
be used in one of the following ways (`$svg' is the return value):

=over

=item *

Write to a file: `$svg->toFile($filename);'

=item *

Save to a string: `my $string = $svg->toString();'

=item *

Write to a file with the XML nicely indented:
`$svg->toFile($filename, 1);'

=item *

Save to a string with the XML nicely indented:
`my $string = $svg->toString(1);'

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE.txt README.md Changes
%perl_vendor_privlib/B*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
