Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
%add_findreq_skiplist %perl_vendor_privlib/Beanstalk/Pool.pm
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Beanstalk-Client
Version:        1.07
Release:        alt2_32
Summary:        Client class to talk to a beanstalkd server
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Beanstalk-Client
Source0:        https://cpan.metacpan.org/authors/id/G/GB/GBARR/Beanstalk-Client-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Class/Accessor/Fast.pm)
BuildRequires:  perl(IO/Socket/INET.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(YAML/Syck.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(version.pm)
Source44: import.info
# Optional tests:
# JSON::XS is not used

%description
Beanstalk::Client provides a Perl API of protocol version 1.0 to the
beanstalkd server, a fast, general-purpose, in-memory work-queue service by
Keith Rarick.

%prep
%setup -q -n Beanstalk-Client-%{version}
rm -rf inc/*
sed -i -e '/^inc\//d' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} \;
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/Beanstalk

%changelog
