%define module_name Beekeeper
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/HTTP.pm) perl(Compress/Raw/Zlib.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir/Install.pm) perl(JSON/XS.pm) perl(Term/ReadKey.pm) perl(Test/Class.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Framework for building applications with a microservices architecture
Group: Development/Perl
License: perl
URL: https://github.com/jmico/beekeeper

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JM/JMICO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Beekeeper is a framework for building applications with a microservices architecture.

=begin HTML

<p><img src="https://raw.githubusercontent.com/jmico/beekeeper/master/doc/images/beekeeper.svg"/></p>

=end HTML

A pool of worker processes handle requests and communicate with each other through a common message bus.

Clients send requests through a different set of message buses, which are isolated for security reasons.

Requests and responses are shoveled between buses by a few router processes.


Benefits of this architecture:

- Scales horizontally very well. It is easy to add or remove workers or brokers.

- High availability. The system remains responsive even when several components fail.

- Easy integration of browsers via WebSockets or clients written in other languages.


Key characteristics:

- Broker is a messaging server like Apache ActiveMQ or RabbitMQ.

- Broker protocol is STOMP (see the specification at https://stomp.github.io/stomp-specification-1.2.html).

- RPC protocol is JSON-RPC 2.0 (see the specification at https://www.jsonrpc.org/specification).

- Message marshalling is JSON.

- No message persistence in the broker, it just passes on messages.

- No routing logic is defined in the broker.

- Efficient multicast and unicast notifications.

- Inherent load balancing.


What does this framework provides:

- `Beekeeper::Worker', a base class for writing service workers with almost no additional code.

- `Beekeeper::Client', a class for writing service clients.

- `bkpr' command which spawns and controls worker processes.

- Command line tools for monitoring and controlling remotely worker pools.

- A simple internal broker handy for development or running tests. 

- Automatic message routing between frontend and backend buses.

- Centralized logging, which can be shoveled to an external monitoring application.

- Performance metrics gathering, which can be shoveled to an external monitoring application.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE examples
%perl_vendor_privlib/B*
%perl_vendor_privlib/auto/*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
