# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Begin-Eval-FirstArg
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Take code from first command-line argument, then eval it
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Begin-Eval-FirstArg

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to evaluate Perl code specified in the first command-line
argument, basically for convenience in one-liners.

Caveat: to run the code(s) in BEGIN block, you have to load the module in the
BEGIN block also, e.g. via "use" not "require".

The purpose of Begin::Eval::* and End::Eval::* modules is to allow you to
evaluate some extra Perl code in addition to running your application,
respectively at the beginning and at the end. The code can be supplied via one
of these means: first command-line argument, environment variable(s). Previously
there are Begin::Eval and End::Eval modules that accept code from import
arguments, but the limited syntax provided by perl's `-M' switch diminishes the
usefulness of the modules. Thus the modules are removed from CPAN.

Use cases include:

=over

=item * printing \%%INC at the start of your program run

 %% perl -MBegin::Eval::FirstArg /path/to/your-script.pl 'print "$_\n" for sort keys %%INC' script-arg1 ...
 %% PERL_BEGIN_EVAL_END='print "$_\n" for sort keys %%INC' perl -MBegin::Eval::Env /path/to/your-script.pl script-arg1 ...

To know which modules are loaded before your program runs.

=item * printing \%%INC at the beginning of your program run

To know all the modules that are loaded during your program run.

=item * loading a module at the beginning of your program, with some initialization

=back

Alternatives to using these modules include using "do":

 %% perl -E 'your-extra-code-before-running-program; do "/path/to/your/script.pl"; your-extra-code-after-running-program'

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/B*

%changelog
