# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(BenchmarkAnything/Reporter.pm) perl(Class/Accessor.pm) perl(Class/Accessor/Fast.pm) perl(Class/MethodMaker.pm) perl(Class/XSAccessor.pm) perl(Class/XSAccessor/Array.pm) perl(Clone.pm) perl(Devel/AssertOS.pm) perl(Devel/CheckOS.pm) perl(File/Copy/Recursive.pm) perl(File/Find/Rule.pm) perl(File/HomeDir.pm) perl(File/ShareDir.pm) perl(Mail/SpamAssassin.pm) perl(Math/GMP.pm) perl(Moo.pm) perl(Moose.pm) perl(MooseX/Declare.pm) perl(Mouse.pm) perl(Object/Tiny/RW.pm) perl(POSIX/Regex.pm) perl(Test/EOL.pm) perl(Test/Pod.pm) perl(YAML.pm) perl(experimental.pm) perl(threads.pm) perl(threads/shared.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Benchmark-Perl-Formance
%define upstream_version 0.55

%{?perl_default_filter}
%global __requires_exclude_from %{?__requires_exclude_from:%__requires_exclude_from|}^%{_docdir}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    Benchmark Suite for Perl
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Benchmark/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Config/Perl/V.pm)
BuildRequires: perl(Data/DPath.pm)
BuildRequires: perl(Data/Structure/Util.pm)
BuildRequires: perl(Data/YAML/Reader.pm)
BuildRequires: perl(Data/YAML/Writer.pm)
BuildRequires: perl(Devel/Platform/Info.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Math/MatrixReal.pm)
BuildRequires: perl(Math/Primality.pm)
BuildRequires: perl(Module/Pluggable.pm)
BuildRequires: perl(Module/Runtime.pm)
BuildRequires: perl(Sys/Hostname.pm)
BuildRequires: perl(Sys/Info.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This benchmark suite tries to run some stressful programs and outputs values
that you can compare against other runs of this suite, e.g. with other versions
of Perl, modified compile parameter, or another set of dependent libraries.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%{_bindir}/benchmark-perlformance
%{_bindir}/benchmark-perlformance-set-stable-system
%{_mandir}/man1/*
%{perl_vendor_privlib}/*

%changelog
