%define module_name Benchmarks
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators perl(Module/Build.pm)

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: The comparison benchmarker
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BA/BAYASHI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Benchmarks is the the Benchamark manpage wrapper for comparing routines easily.

When this module was loaded, all you need to do is pass the CODE reference that returns hash reference.

    use Benchmarks sub {
        +{
            'routine_name_1' => sub { '... some code ...' },
            'routine_name_2' => sub { '... some code ...' },
        };
    };

Then the comparison will be invoked and show the result like below.

    Benchmark: running raise, times for at least 1 CPU seconds...
         raise: -1 wallclock secs ( 1.07 usr +  0.00 sys =  1.07 CPU) @ 8895180.37/s (n=9517843)
         times:  2 wallclock secs ( 1.10 usr +  0.00 sys =  1.10 CPU) @ 4051316.36/s (n=4456448)
               Rate times raise
    times 4051316/s    --  -54%%
    raise 8895180/s  120%%    --

NOTE that `Benchmarks' exports *ALL* functions from `Benchmark'. You can use `Benchmarks' module as same as Benchmark module.

    use Benchmarks;

    timethis (-1, sub { bless +{}, 'Foo' } );

More information about functions: https://metacpan.org/pod/Benchmark#Standard-Exports and https://metacpan.org/pod/Benchmark#Optional-Exports

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc README.pod Changes
%perl_vendor_privlib/B*

%files scripts
%_bindir/*

%changelog
