Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/Annotation/Comment.pm) perl(Bio/Annotation/DBLink.pm) perl(Bio/Annotation/OntologyTerm.pm) perl(Bio/Annotation/Reference.pm) perl(Bio/Annotation/SimpleValue.pm) perl(Bio/Cluster/SequenceFamily.pm) perl(Bio/Index/AbstractSeq.pm) perl(Bio/Ontology/Term.pm) perl(Bio/Root/Test.pm) perl(Bio/Seq.pm) perl(Bio/SeqFeature/Gene/Exon.pm) perl(Bio/SeqFeature/Gene/GeneStructure.pm) perl(Bio/SeqFeature/Gene/Transcript.pm) perl(Bio/SeqFeature/Generic.pm) perl(Bio/SeqIO.pm) perl(Bio/Species.pm) perl(Carp.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/EOL.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(base.pm) perl(lib.pm) perl(parent.pm)
BuildRequires: perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bio-ASN1-EntrezGene
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.73
Release: alt1
Summary: Regular expression-based Perl Parser for NCBI Entrez Gene.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-ASN1-EntrezGene

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Bio::ASN1::EntrezGene is a regular expression-based Perl Parser for NCBI Entrez
Gene genome databases (http://www.ncbi.nih.gov/entrez/query.fcgi?db=gene).  It
parses an ASN.1-formatted Entrez Gene record and returns a data structure that
contains all data items from the gene record.

The parser will report error & line number if input data does not conform to the
NCBI Entrez Gene genome annotation file format.

Note that it is possible to provide reading of all NCBI's ASN.1-formatted
files through simple variations of the Entrez Gene parser (I need more
investigation to be sure, but at least the sequence parser is a very simple
variation on Entrez Gene parser and works well).

It took the parser version 1.0 11 minutes to parse the human genome Entrez Gene
file on one 2.4 GHz Intel Xeon processor.  The addition of validation and error
reporting in 1.03 and handling of new Entrez Gene format slowed the parser down
about 40%%.

Since V1.07, this package also included an indexer that runs pretty fast (it
takes 21 seconds for the indexer to index the human genome on the same
processor).  Therefore the combination of the modules would allow user to
retrieve and parse arbitrary records.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE examples
%perl_vendor_privlib/B*

%changelog
