# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/AlignIO.pm) perl(Bio/Root/Test.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(GD.pm) perl(GD/Simple.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(POSIX.pm) perl(Test/Exception.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Warn.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bio-Align-Graphics
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.3
Release: alt1
Summary: Graphic Rendering of Bio::Align::AlignI Objects
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-Align-Graphics

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Bio::Align::Graphics is a module designed to create image files out of Bio::Align::AlignI objects.  An alignment may be manipulated with various 
formatting and highlighting options.

An example:

_#!/usr/bin/perl -w

_use Bio::AlignIO;
_use Bio::Align::Graphics;
_use strict;
_
_#Get an alignment file
_my $file = shift @ARGV;
_
_#Create an AlignI object using AlignIO
_my $in=new Bio::AlignIO(-file=>$file, -format=>'clustalw');

_#Read the alignment
_my $aln=$in->next_aln();

_#Create some domains for highlighting
_my @domain_start = ( 25 , 50, 80 );
_my @domain_end = ( 40 , 60 , 100 );
_my @domain_color = ( 'red' , 'cyan' , 'green' );
_
_#Create Labels for the domains
_my @dml = ("CARD", "Proline Rich", "Transmembrane");
_my @dml_start = (25, 50, 80);
_my @dml_end = (40, 60, 100);
_my @dml_color = ("lightpink", "lightblue", "lightgreen");
_
_
_#Create individual labels
_my %%labels = ( 145 => "Hep-c target");
_
_
_my $print_align = new Bio::Align::Graphics( align => $aln,
_____pad_bottom => 5,
_____domain_start => \@domain_start,
_____domain_end => \@domain_end,
_____dm_color => \@domain_color,
_____dm_labels => \@dml,
_____dm_label_start => \@dml_start,
_____dm_label_end => \@dml_end,
_____dm_label_color => \@dml_color,
_____labels => \%%labels,
_____out_format => "png");
_____
_$print_align->draw();

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes
%perl_vendor_privlib/B*

%changelog
