%define module_version 1.04
%define module_name Bio-CUA
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/SeqIO.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Sort.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(base.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: Codon Usage Analyzer.
Group: Development/Perl
License: gpl
URL: http://molevol.altervista.org/

Source0: http://cpan.org.ua/authors/id/F/FO/FORTUNE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The aim of this distribution is to provide comprehensive and flexible
tools to analyze codon usage bias (CUB) and relevant problems, so that
users can speed up the genetic research by taking advantage of this
convenience.

One amino acid can be encoded by more than one synonymous codon, and
synonymous codons are unevenly used. For example, some codons are used
more often than other synonymous ones in highly expressed genes (*Sharp
and Li 1987*). To measure the unevenness of codon usage, multiple
metrics of codon usage bias have been developed, such as Fop
(Frequency of optimal codons), CAI (Codon Adaptation Index), tAI (tRNA
Adaptation Index), and ENC (Effective Number of Codons). The causes of
CUB phenomena are complicated, including, mutational bias, selection on 
translational efficiency or accurancy. CUB is one fundamental concept
in genetics. 

So far, no software exists to compute all the above CUB metrics, and
more importantly parameters of CUB calculations are often fixed in
software, so one can only analyze genes in a limited list of species
and one can not incorporate its own parameters such as sequences of
highly expressed genes in a tissue. 

This package mainly solves these two problems. We also extend some
methods, such as GC-content corrected ENC, background-data normalized
CAI, etc. See the relevant methods in CUB classes for more details.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE TODO README Changes
%perl_vendor_privlib/B*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
