%define module_name Bio-DB-USeq
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(Bio/Root/Version.pm) perl(Module/Build.pm) perl(Pod/Usage.pm) perl(Set/IntervalTree.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.26
Release: alt1
Summary: Read USeq archive database files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TJ/TJPARNELL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Bio::DB::USeq is a BioPerl style adaptor for reading USeq files. USeq files 
are compressed, indexed data files supporting modern bioinformatic datasets, 
including genomic points, scores, and intervals. More information about the 
format can be found at http://useq.sourceforge.net/useqArchiveFormat.html. 

USeq files are typically half the size of corresponding bigBed and bigWig files, 
due to a compact internal format and lack of internal zoom data. This adaptor, 
however, can still return statistics across different zoom levels in the same 
manner as big files, albeit at a cost of calculating these in realtime.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES README
%perl_vendor_privlib/B*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
