# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/Root/Root.pm) perl(Bio/Root/Test.pm) perl(Bio/SeqIO.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(SVG.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(base.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bio-Draw-Pictogram
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.3
Release: alt1
Summary: generate SVG output of Pictogram display for consensus motifs
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-Draw-Pictogram

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A module for generating SVG output of Pictogram display for consensus
motifs.  This method of representation was describe by Burge and
colleagues: (Burge, C.B.,Tuschl, T., Sharp, P.A. in The RNA world II,
525-560, CSHL press, 1999)

This is a simple module that takes in an array of sequences (assuming
equal lengths) and calculates relative base frequencies where the
height of each letter reflects the frequency of each nucleotide at a
given position. It can also plot the information content at each
position scaled by the background frequencies of each nucleotide.

It requires the SVG-2.26 or later module by Ronan Oger available at
http://www.cpan.org

Recommended viewing of the SVG is the plugin available at Adobe:
http://www.adobe.com/svg

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE
%perl_vendor_privlib/B*

%changelog
