%define module_name Bio-FastParsers
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Const/Fast.pm) perl(Exporter/Easy.pm) perl(ExtUtils/MakeMaker.pm) perl(List/AllUtils.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(Path/Class.pm) perl(Smart/Comments.pm) perl(Sort/Naturally.pm) perl(Test/Most.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Tie/IxHash.pm) perl(Try/Tiny.pm) perl(XML/Bare.pm) perl(aliased.pm) perl(autodie.pm) perl(feature.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.221230
Release: alt1
Summary: Classes for parsing bioinformatic programs output
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBAURAIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution includes modules for parsing the output files of a selection
of sequence comparison programs, including BLAST
https://blast.ncbi.nlm.nih.gov/, HMMER http://hmmer.org/, CD-HIT
https://github.com/weizhongli/cdhit and UCLUST
http://www.drive5.com/usearch/.

These classes are designed to add as few overhead as possible, using
constructs not far from those that would be found in home-made parsing
scripts. Moreover, their API stick closer to the behavior of each individual
software. In this respect, the approach of these parsers is very different
from Bioperl's the Bio::SearchIO manpage. Hence, `Bio::FastParsers' classes do not
need (and are not meant as a replacement for) the BioPerl manpage.

`Bio::FastParsers' modules have been used in production since 2013 but were
not yet ready for wider adoption due to their lack of documentation. This is
now nearly fixed: all modules are documented except for HMMER parsers.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/B*

%changelog
