%define module_version 0.05
%define module_name Bio-FdrFet
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Inline.pm) perl(Inline/C.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Perl extension for False Discovery Rate and Fisher Exact Test applied to pathway analysis.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BR/BRUC/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Bio::FdrFet implements the False Discovery Rate Fisher Exact Test of gene.expression analysis applied to pathways described in the paper by
Ruiru Ji, Karl-Heinz Ott, Roumyana Yordanova, and Robert E
Bruccoleri.  A copy of the paper is included with the distribution in
the file, Fdr-Fet-Manuscript.pdf.

The module is implemented using a simple object oriented paradigm
where the object stores all the information needed for a calculation
along with a state variable, `STATE'. The state variable has two
possible values, `'setup'' and `'calculated''. The value of
`'setup'' indicates that the object is being setup with data, and any
results in the object are inconsistent with the data. The value of
`'calculated'' indicates that the object's computational results are
consistent with the data, and may be returned to a calling program.

The `'calculate'' method is used to update all the calculated values
from the input data. It checks the state variable first, and only does
the calculation if the state is `'setup''. Once the calculations are
complete, then the state variable is set to `'calculated''. Thus, the `calculate' method
can be called whenever a calculated value is needed, and there is no
performance penalty.

The module initializes the `Bio::FdrFet' object with a state of
`'setup''. Any data input sets the state to `'setup''. Any requests
for calculated data, calls `'calculate'', which updates the state
variable so futures requests for calculated data return quickly.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/B*

%files scripts
%_bindir/*

%changelog
