# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/AnnotatableI.pm) perl(Bio/Annotation/Collection.pm) perl(Bio/Annotation/Comment.pm) perl(Bio/Annotation/DBLink.pm) perl(Bio/Annotation/OntologyTerm.pm) perl(Bio/Annotation/SimpleValue.pm) perl(Bio/Annotation/Target.pm) perl(Bio/FeatureHolderI.pm) perl(Bio/LocatableSeq.pm) perl(Bio/Location/Simple.pm) perl(Bio/Ontology/OntologyStore.pm) perl(Bio/OntologyIO.pm) perl(Bio/Root/IO.pm) perl(Bio/Root/Root.pm) perl(Bio/Root/Test.pm) perl(Bio/SeqFeature/AnnotationAdaptor.pm) perl(Bio/SeqFeature/Generic.pm) perl(Bio/SeqFeature/TypedSeqFeatureI.pm) perl(Bio/SeqIO.pm) perl(Bio/Tools/GFF.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Symbol.pm) perl(Test/More.pm) perl(Test/Pod.pm)
BuildRequires: perl(Test/Pod/Coverage.pm) perl(Tree/DAG_Node.pm) perl(URI/Escape.pm) perl(XML/DOM.pm) perl(XML/DOM/XPath.pm) perl(base.pm) perl(constant.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bio-FeatureIO
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.6.905
Release: alt1
Summary: Modules for reading, writing, and manipulating sequence features
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-FeatureIO

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
An I/O iterator subsystem for genomic sequence features.

Bio::FeatureIO is a handler module for the formats in the FeatureIO set (eg,
Bio::FeatureIO::GFF). It is the officially sanctioned way of getting at the
format objects, which most people should use.

The Bio::FeatureIO system can be thought of like biological file handles. They
are attached to filehandles with smart formatting rules (eg, GFF format, or BED
format) and can either read or write feature objects (Bio::SeqFeature objects,
or more correctly, Bio::FeatureHolderI implementing objects, of which
Bio::SeqFeature is one such object). If you want to know what to do with a
Bio::SeqFeatureI object, read the Bio::SeqFeatureI manpage.

The idea is that you request a stream object for a particular format. All the
stream objects have a notion of an internal file that is read from or written
to. A particular FeatureIO object instance is configured for either input or
output. A specific example of a stream object is the Bio::FeatureIO::gff object.

Each stream object has functions:

  $stream->next_feature();
  $stream->write_feature($feature);

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/B*

%changelog
