%define module_name Bio-MUST-Core
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/NeedlemanWunsch.pm) perl(Archive/Zip.pm) perl(Bio/LITE/Taxonomy/NCBI.pm) perl(Bio/LITE/Taxonomy/NCBI/Gi2taxid.pm) perl(Bio/Phylo/IO.pm) perl(Carp.pm) perl(Config/Any.pm) perl(Const/Fast.pm) perl(Date/Format.pm) perl(Exporter/Easy.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Find/Rule.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Getopt/Euclid.pm) perl(Graphics/ColorNames.pm) perl(Graphics/ColorNames/HTML.pm) perl(Graphics/ColorNames/WWW.pm) perl(HTTP/Request/Common.pm) perl(IPC/System/Simple.pm) perl(LWP/Protocol/https.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(List/AllUtils.pm) perl(List/Compare.pm) perl(Modern/Perl.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/NonMoose.pm) perl(MooseX/SemiAffordanceAccessor.pm)
BuildRequires: perl(MooseX/Storage.pm) perl(POSIX.pm) perl(Path/Class.pm) perl(Scalar/Util.pm) perl(Smart/Comments.pm) perl(Statistics/Descriptive.pm) perl(Storable.pm) perl(Test/Deep.pm) perl(Test/Files.pm) perl(Test/Most.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Portability/Files.pm) perl(Tie/IxHash.pm) perl(Try/Tiny.pm) perl(Try/Tiny/Warnings.pm) perl(XML/Bare.pm) perl(YAML/XS.pm) perl(aliased.pm) perl(autodie.pm) perl(feature.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%set_perl_req_method relaxed
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.240390
Release: alt1
Summary: Core classes and utilities for Bio::MUST
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBAURAIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution is the base of the `Bio::MUST' module collection designed
for writing phylogenomic applications in Perl. Their main strength lies in
their transparent handling of the NCBI Taxonomy database (see
https://www.ncbi.nlm.nih.gov/taxonomy), for example to automatically label
ancestral nodes in phylogenetic trees.

`Bio::MUST' classes do not need (and are not meant as a replacement for)
the BioPerl manpage. In contrast, they depend on both the Bio::LITE::Taxonomy manpage and
the Bio::Phylo manpage, two non-BioPerl distribution for dealing with biological data.

`Bio::MUST' modules have been used in production since 2013 but are not yet
ready for wider adoption due to their lack of documentation. This should
improve over time. Meanwhile, adventurous users can have a look at the
the Bio::MUST::Core::Ali manpage class which is already fully documented.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/B*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
