%define module_name Bio-Phylo-Forest-DBTree
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/Phylo.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DBIx/Class.pm) perl(ExtUtils/MakeMaker.pm) perl(Pod/Usage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.1
Release: alt1
Summary: DBIx::Class-backed, Bio::Phylo-like API for large phylogenies
Group: Development/Perl
License: perl
URL: http://biophylo.blogspot.com/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RV/RVOSA/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This package provides the functionality to handle very large phylogenies (examples: the
NCBI taxonomy, the Green Genes tree) as if they are the Bio::Phylo manpage tree objects, with all 
the possibilities for traversal, computation, serialization, and visualization, but stored
in a SQLite database. These databases are single files, so that they can be easily shared.
Some useful database files are available here: 
https://figshare.com/account/home#/projects/18808

To make new tree databases, a number of scripts are provided with the distribution of this
package:

=over

=item * `megatree-loader' Loads a very large Newick tree into a database.

=item * `megatree-ncbi-loader' Loads the NCBI taxonomy dump into a database.

=item * `megatree-phylotree-loader' Loads a tree in the format of http://phylotree.org
into a database.

=back

As an example of interacting with a database tree, the script `megatree-pruner' can be
used to extract subtrees from a database.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING LICENSE README.md
%perl_vendor_privlib/B*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
