# BEGIN SourceDeps(oneline):
BuildRequires: perl(BioX/Workflow.pm) perl(Data/Pairs.pm) perl(Interpolation.pm) perl(Module/Build/Tiny.pm) perl(Moose/Role.pm) perl(Test/More.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define module_version 0.12
%define module_name BioX-Workflow-Plugin-Drake
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: A very opinionated template based bioinformatics workflow writer for Drake.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JI/JILLROWE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The main documentation for this module is at the BioX::Workflow manpage. This module extends Workflow in order to add functionality for outputing workflows in drake format.

    biox-workflow.pl --workflow workflow.yml > workflow.drake
    drake --workflow workflow.drake  #with other functionality such as --jobs for asynchronous output, etc.

    List your plugins in your workflow.yml file

    ---
    plugins:
        - Drake
    global:
        - indir: /home/user/gemini
        - outdir: /home/user/gemini/gemini-wrapper
        - file_rule: (.vcf)$|(.vcf.gz)$
        - infile:
        - min: 1 ##IF USING MIN
    #So On and So Forth

More information about Drake can be found here https://github.com/Factual/drake.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes example
%perl_vendor_privlib/B*

%changelog
