%define module_name Blockchain-Ethereum-Keystore
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bitcoin/Crypto.pm) perl(Crypt/Perl.pm) perl(Crypt/ScryptKDF.pm) perl(CryptX.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(JSON/MaybeXS.pm) perl(Net/SSH/Perl.pm) perl(Test/CPAN/Meta.pm) perl(Test/CheckDeps.pm) perl(Test/DistManifest.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Portability/Files.pm) perl(Test/Version.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.011
Release: alt1
Summary: Ethereum keystorage utilities
Group: Development/Perl
License: mit
URL: https://github.com/refeco/Blockchain-Ethereum-Keystore

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RE/REFECO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Collection of utilities for keystore management

Examples:

Generating a new address and writing it to a keyfile:

    my $key = Blockchain::Ethereum::Keystore::Key->new;
    # checksummed address
    print $key->address;
    my $keyfile = Blockchain::ethereum::Keystore::Keyfile->new;

    $keyfile->import_key($key);
    $keyfile->write_to_file("...");
    ...

Generating a new seed and derivating new keys (BIP44):

    my $seed = Blockchain::Ethereum::Keystore::Seed->new;
    my $key = $seed->derive_key(0);
    print $key->address;
    ...

Importing a keyfile and changing the password:

    my $keyfile = Blockchain::Ethereum::Keystore::Keyfile->new;
    my $password = "old_password";
    $keyfile->import_file("...", $password);
    $keyfile->change_password($password, "newpassword");
    $keyfile->write_to_file("...");

Signing a transaction:

    my $transaction = Blockchain::Ethereum::Transaction::EIP1559->new(
        ...
    );

    my $keyfile = Blockchain::Ethereum::Keystore::Keyfile->new;
    $keyfile->import_file("...");
    $keyfile->private_key->sign_transaction($transaction);

Export private key:

    my $keyfile = Blockchain::Ethereum::Keystore::Keyfile->new;
    $keyfile->import_file("...");

    # private key bytes
    print $keyfile->private_key->export;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/B*

%changelog
