# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bit/Vector.pm) perl(Digest/MurmurHash.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(MCE/Grep.pm) perl(Storable.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Bloom-Scalable
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Implementation of the probalistic datastructure - ScalableBloomFilter
Group: Development/Perl
License: Artistic_2_0
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SU/SUBBU/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Bloom Filters were around since 1970 as a probabilistic datastructures
primarily used for their property of configurable false positives 
but *no* false negatives.

While risking false positives, Bloom filters have a strong space advantage
over other data structures for representing sets.
A Bloom filter with 1%% error and an optimal value of k(number of filters) 
requires only about 9.6 bits per element .ei regardless of the size of the elements. 
This advantage comes partly from its compactness, inherited from arrays, 
and partly from its probabilistic nature. 
The 1%% false-positive rate can be reduced by a factor of ten 
by adding only about 4.8 bits per element.

Bloom filters also have the unusual property that the time needed either to add items 
or to check whether an item is in the set is a fixed constant, O(k), 
completely independent of the number of items already in the set.
No other constant-space set data structure has this property,

Scalable Bloom Filter entered the stage a bit later, primarily due to the work of
Paulo Sergio Almeida, Carlos Baquero, Nuno Preguica(Lancaster University).
Refer to their research paper titled - "Scalable Bloom Filter"
Their rationale was a Scalable Bloom Filter could be created by chaining together filters
with decreasing error probabilities so that that the entire datastructure respects the predefined
false positive probability agreement. The factor for decreasing the false positive probability
as per their work was determined as between 0.8 - 0.9.

Murmur2 Hashing has been used in this module primarily for its speed.
The quality of the hashing has been further fine tuned by using the technique
defined in the paper by Kirsch, Adam; Mitzenmacher, Michael (2006), 
"Less Hashing, Same Performance: Building a Better Bloom Filter"

Persisting the BloomFilter, using the Perl MultiCoreEngine are a couple of bells and whistles
added for ease and performance.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/B*

%changelog
