# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/Scurvy/Whoreson/BilgeRat.pm) perl(Bot/Backbone.pm) perl(Bot/Backbone/Service.pm) perl(Bot/Backbone/Service/Role/Responder.pm) perl(Bot/Backbone/Service/Role/Service.pm) perl(Bot/Backbone/Service/Role/Storage.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(Hailo.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(MooseX/Types/Path/Class.pm) perl(Pod/Coverage/TrustPod.pm) perl(Readonly.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bot-Backbone-Service-OFun
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.142230
Release: alt1
Summary: Services for Bot::Backbone optimized for fun
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HANENKAMP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a collection of modules designed for use with the Bot::Backbone manpage to help
make it easy to create bot with various fun features. Many of these services
require additional input files or configuration and may also require
a database for persistent storage of information. As much as possible, I've
tried to implement these in a standardish way. 

In the case of persistent storage, I had to choose something, so I chose
the DBI manpage, which is made avaialble through the
the Bot::Backbone::Service::Role::Storage manpage.

Here's a list of the included services and what they each do:

=over

=item *

the Bot::Backbone::Service::OFun::CodeName manpage. This is a service that gives you a
`!codename' command that will generate a code name for a word or phrase, which
can be a fun way of assigning secret names to your project. It requires storage
to save the code names as they are assigned and a couple of word lists.

=item *

the Bot::Backbone::Service::OFun::Dice manpage. This is a very simple service that
provides a few commands related to picking numbers at random. The <!roll>
command will roll a set of dice according to standard dice notation. The
`!flip' command will flip a coin. The `!choose' command can choose items
from a list. The `!shuffle' command takes a list and shuffles it to display
again.

=item *

the Bot::Backbone::Service::OFun::Hailo manpage. This is a conversation generator. If
someone addresses the bot directly, the bot will respond using the Hailo manpage. This
will save the markov chains learned and used to generate the conversation in a
SQLite database.

=item *

the Bot::Backbone::Service::OFun::Insult manpage. This provides a `!insult' command
based upon the the Acme::Whoresone::Scurvy::Bilgerat manpage insult generator.

=item *

the Bot::Backbone::Service::OFun::Karma manpage. This provides a karma/score tracker.
Any time someone uses a ++ or -- notation on a word or phrase, that word or
phrase will have a score recorded. You can then see the list of highest and
lowest sco...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/B*

%changelog
