# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurper.pm) perl(Getopt/Long.pm) perl(JSON.pm) perl(List/Util.pm) perl(Log/Report.pm) perl(Path/Class.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(XML/Compile.pm) perl(XML/Compile/Cache.pm) perl(XML/LibXML.pm)
# END SourceDeps(oneline)
%define module_name Business-CAMT
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: ISO20022 Cash Management (CAMT) messages
Group: Development/Perl
License: perl
URL: http://perl.overmeer.net

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MARKOV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Use this module to manage CAMT messages, which are ISO20022 standard
"Cash Management" messages as produced in banking.  For instance,
CAMT.053 is produced by banks and consumed by accountancies, showing
transactions in bank-accounts.  See https://www.iso20022.org.

At the moment, this module can be used to read and write the XML
message files, perfectly validated and predictable.  It is intended to
also support abstraction in interpreting and constructing the content.

However, I need a sponsor to make that happen.  Contact the author
for support.  Please.  I would also like to include a CAMT.053 to CSV
and MT-940 converter, v.v.  Please hire me.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md ChangeLog examples
%perl_vendor_privlib/B*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
