%define module_name Business-CompanyDesignator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Data/Dump.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(File/ShareDir.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Regexp/Assemble.pm) perl(Test/Exception.pm) perl(Test/Files.pm) perl(Test/More.pm) perl(Unicode/Normalize.pm) perl(YAML.pm) perl(YAML/Tiny.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: module for matching and stripping/manipulating the company designators appended to company names
Group: Development/Perl
License: perl
URL: https://github.com/gavincarr/Business-CompanyDesignator

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GA/GAVINC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Business::CompanyDesignator is a perl module for matching and stripping/manipulating
the typical company designators appended (or sometimes, prepended) to company names.
It supports both long forms (e.g. Corporation, Incorporated, Limited etc.) and
abbreviations (e.g. Corp., Inc., Ltd., GmbH etc).

  use Business::CompanyDesignator;

  # Constructor
  $bcd = Business::CompanyDesignator->new;
  # Optionally, you can provide your own company_designator.yml file, instead of the bundled one
  $bcd = Business::CompanyDesignator->new(datafile => '/path/to/company_designator.yml');

  # Get lists of designators, which may be long (e.g. Limited) or abbreviations (e.g. Ltd.)
  @des = $bcd->designators;
  @long = $bcd->long_designators;
  @abbrev = $bcd->abbreviations;

  # Lookup individual designator records (returns B::CD::Record objects)
  # Lookup record by long designator (unique)
  $record = $bcd->record($long_designator);
  # Lookup records by abbreviation or long designator (may not be unique)
  @records = $bcd->records($designator);

  # Get a regex for matching designators by type ('end'/'begin') and lang
  # By default, returns 'end' regexes for all languages
  $re = $bcd->regex;
  $company_name =~ $re and say 'designator found!';
  $company_name =~ /$re\s*$/ and say 'final designator found!';
  my $re_begin_en = $bcd->regex('begin', 'en');

  # Split $company_name on designator, returning a ($before, $designator, $after) triplet,
  # plus the normalised form of the designator matched (can pass to records(), for example)
  ($before, $des, $after, $normalised_des) = $bcd->split_designator($company_name);

  # Or in scalar context, return a the Business::CompanyDesignator::SplitResult manpage object
  $res = $bcd->split_designator($company_name, lang => 'en');
  print join ' / ', $res->designator_std, $res->short_name, $res->extra;



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/B*
%perl_vendor_privlib/auto/*

%changelog
