%define module_name Business-CyberSource-Report
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Load.pm) perl(HTTP/Request.pm) perl(HTTP/Request/Common.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/LWP/UserAgent.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2.0
Release: alt1
Summary: Factory class for modules that retrieve CyberSource's XML reports.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Business-CyberSource-Report

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
use Business::CyberSource::Report;
_use Business::CyberSource::Report::Test;

_# Generate a report factory.
_my $report_factory = Business::CyberSource::Report->new(
__merchant_id           => $merchant_id,
__username              => $username,
__password              => $password,
__use_production_system => $use_production_system,
_);

_# Use the factory to get a Business::CyberSource::Report::Test object with
_# the correct connection parameters.
_my $test_report = $report_factory->build( 'test' );

_# Retrieve a list of the report modules that have been loaded in memory,
_# either via "use" or a require by build()
_my $available_reports = $report_factory->list_loaded();


%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md ignore.txt Changes LICENSE examples
%perl_vendor_privlib/B*

%changelog
