%define module_name CAM-PDFTaxforms
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CAM/PDF.pm) perl(Crypt/RC4.pm) perl(Digest/MD5.pm) perl(Module/Build.pm) perl(Pod/Usage.pm) perl(Test/Memory/Cycle.pm) perl(Test/More.pm) perl(Text/PDF.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.20
Release: alt1
Summary: CAM::PDF wrapper to also allow editing of checkboxes (ie. for IRS Tax forms).
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TU/TURNERJW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package is a wrapper for and creates a the CAM::PDF manpage object.  The 
difference is that some method functions are overridden to fix some 
issues and add some new features, namely to better handle IRS tax 
forms, many of which have checkboxes, in addition to numeric and text 
fields.  Several other patches have also been applied, particularly 
those provided by CAM::PDF bugs #58144, #122890 and #125299.  
Otherwise, it should work well as a full drop-in replacement for 
CAM::PDF in the API.

CAM::PDF description:

This package reads and writes any document that conforms to the PDF
specification generously provided by Adobe at
http://partners.adobe.com/public/developer/pdf/index_reference.html
(link last checked Oct 2005).

The file format through PDF 1.5 is well-supported, with the exception
of the "linearized" or "optimized" output format, which this module
can read but not write.  Many specific aspects of the document model
are not manipulable with this package (like fonts), but if the input
document is correctly written, then this module will preserve the
model integrity.

The PDF writing feature saves as PDF 1.4-compatible.  That means that
we cannot write compressed object streams.  The consequence is that
reading and then writing a PDF 1.5+ document may enlarge the resulting
file by a fair margin.

This library grants you some power over the PDF security model.  Note
that applications editing PDF documents via this library MUST respect
the security preferences of the document.  Any violation of this
respect is contrary to Adobe's intellectual property position, as
stated in the reference manual at the above URL.

Technical detail regarding corrupt PDFs: This library adheres strictly
to the PDF specification.  Adobe's Acrobat Reader is more lenient,
allowing some corrupted PDFs to be viewable.  Therefore, it is
possible that some PDFs may be readable by Acrobat that are illegible
to this library.  In particular, files which have had line endings
converted to or from DOS/Windows style (i.e. C...

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes example
%perl_vendor_privlib/C*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
