# BEGIN SourceDeps(oneline):
BuildRequires: perl(Getopt/Long.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 2.00
%define module_name CDDB-Fake
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.00
Release: alt1
Summary: Fake CDDB entries if you have none
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JV/JV/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Sometimes there's no CDDB file available for a piece of music. For
example, when you created a collection of tracks from other albums. In
this case, a text file containing the name of the artist / album,
followed by a mere list of the track titles can be used as a
fall-back.

CDDB::Fake implements a part of the CDDB::File API based on manually
crafted fall-back files.

I've adopted the convention to name files with CDDB data `.cddb', and
the fake data `.nocddb'.

For example, you can cut the results of a search at Gracenote
(cddb.com) and paste it into the file .nocddb. For example:

    Birelli Lagrene / Standards

       1. C'est Si Bon
       2. Softly, As in a Morning Sunrise
       3. Days of Wine and Roses
      ...
      12. Nuages

The track titles may be optionally followed by trailing TABs (not
spaces) and a MM:SS time indicator (which may have a leading space if
it's M:SS).

Extra track information can be passed on lines that follow the track
title. These lines must start with whitespace, and may not begin with
a number. Anything that follows the list of tracks is considered extra disc information. For example:

    Birelli Lagrene / Standards

       1. C'est Si Bon
          Original version
       2. Softly, As in a Morning Sunrise
          Live recording.
          Probably incomplete.
       3. Days of Wine and Roses
      ...
      12. Nuages

    This album was recorded in the Olympia Studios in Paris.

Multiple lines of additional info are concatenated with newlines
inbetween. However, if one of the lines contains `\n' (that's
backslash-n), all lines are conctenated using a single whitespace, and
the `\n''s are turned into real newlines.

A tool is included to generate a fake file from the names of the files
in the directory.

WARNING: CDDB::Fake implements only a part of the CDDB::File API.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc CHANGES Changes README
%perl_vendor_privlib/C*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
