%define module_name CGI-Application-Plugin-OpenTracing
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI/Application.pm) perl(Data/Perl/Role/Collection/Hash.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(HTTP/Headers.pm) perl(HTTP/Status.pm) perl(LWP/UserAgent.pm) perl(OpenTracing/GlobalTracer.pm) perl(OpenTracing/Implementation.pm) perl(OpenTracing/Implementation/Test.pm) perl(Ref/Util.pm) perl(Syntax/Feature/Maybe.pm) perl(Test/MockObject.pm) perl(Test/Most.pm) perl(Test/OpenTracing/Integration.pm) perl(Test/WWW/Mechanize/CGIApp.pm) perl(Time/HiRes.pm) perl(syntax.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.103.3
Release: alt1
Summary: Use OpenTracing in CGI Applications
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SN/SNEZ/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This plugin will use the return value from the `opentracing_implementation'
callback to bootstrap a the OpenTracing::GlobalTracer manpage, with
the OpenTracing::Implementation manpage. It uses all the parameters as mentioned in that
`set' method.

It will automatically create a new tracer, with a total of four spans:

=over

=item cgi_application

This is the root span, wich will have a start time at the beginning of the cgi
request, and last till the entire request will be finished.

=back

On top of this rootspan, the following three child-spans will be created:

=over

=item setup

A childspan, that will take the duration of the entire setup process.

=item run

After the tracer has been setup (using the information from the callback), this
span will be started for the actual duration of the request handling

=item teardown

OOPS `...' not implemented (yet)

=back

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE.md CHANGES examples
%perl_vendor_privlib/C*

%changelog
