%define module_name CGI-Application-Plugin-RunmodeParseKeyword
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(CGI.pm) perl(CGI/Application.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Parse/Keyword.pm) perl(Sub/Name.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: Declare cgiapp runmodes with keywords
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RH/RHESA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to declare run modes with a simple keyword. It provides
method signatures similar to the Method::Signatures::Simple manpage.

It respects inheritance: run modes defined in the superclass are also available
in the subclass.

Beyond automatically registering the run mode, and providing `$self', it also
optionally pulls named parameters from `$self->query->param' or
`$self->param'.

=over 4

=item * Basic example

    runmode foo { $self->bar }

This declares the run mode "foo". Notice how `$self' is ready for use.

=item * Rename invocant

    runmode bar ($c:) { $c->baz }

Same as above, only use `$c' instead of `$self'.

    use CGI::Application::Plugin::RunmodeParseKeyword invocant => '$c';
    runmode baz { $c->quux }

Same as above, but every runmode gets `$c' by default. You can still say `runmode ($self:)'
to rename the invocant.

=item * With a parameter list

    runmode baz ( $id, $name ) {
        return $self->wibble("I received $id and $name from a form submission
                              or a method invocation.");
    }

Here, we specify that the method expects two parameters, `$id' and `$name'.
Values can be supplied through a method call (e.g. `$self->baz(1, "me")'),
or from the cgiapp object (e.g. `$self->param( id => 42 )'), or from the
query object (e.g. from `/script?id=42;name=me').

=item * with default values for parameters

    runmode quux ($page = 1, $rows = 42) {
        ...
    }

Here we specify default values for the `$page' and <$rows> parameters. These
defaults will be set in the absence of cgiapp params or query params.

=item * Code attributes

    runmode secret :Auth { ... }

Code attributes are supported as well.

=item * Combining with other ways to set run modes

This all works:

    sub setup {
        my $self = shift;
        $self->run_modes([ qw/ foo / ]);
    }

    sub foo {
        my $self = shift;
        return $self->other;
    }

    runmode bar {
        return $self->other;
    }

    sub other : Runmode {
        my $self = s...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/C*

%changelog
