Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI/Application/Dispatch.pm) perl(CGI/Application/Server.pm) perl(Config/Auto.pm) perl(DBD/mysql.pm) perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
%add_findprov_skiplist %perl_vendor_privlib/CGI/Application/Structured/Tools/templates/*
%add_findreq_skiplist %perl_vendor_privlib/CGI/Application/Structured/Tools/templates/*
BuildRequires: perl-HTML-Template
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-CGI-Application-Structured-Tools
Version:        0.015
Release:        alt2_34
Summary:        Tools to generate and maintain CGI::Application::Structured based web apps
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/CGI-Application-Structured-Tools
Source0:        https://cpan.metacpan.org/authors/id/V/VA/VANAMBURG/CGI-Application-Structured-Tools-%{version}.tar.gz
Patch0:         CGI-Application-Structured-Tools-0.015-Adapt-to-Module-Starter-1.71.patch
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(CGI/Application/Structured.pm)
BuildRequires:  perl(DBIx/Class/Schema/Loader.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Slurp.pm)
BuildRequires:  perl(HTML/Template.pm)
BuildRequires:  perl(Module/Signature.pm)
BuildRequires:  perl(Module/Starter.pm)
BuildRequires:  perl(Module/Starter/Plugin/Template.pm)
BuildRequires:  perl(Module/Starter/Simple.pm)
BuildRequires:  perl(Pod/Coverage.pm)
BuildRequires:  perl(Probe/Perl.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/WWW/Mechanize/CGIApp.pm)

# RPM 4.8 style:
%filter_from_requires /main_module>)/d; /perl.<tmpl_var.pm./d; /perl(<tmpl_var/d

# RPM 4.9 style:



Source44: import.info

%description
A simple, medium-weight, MVC, DB web micro-framework built on
CGI::Application. The framework combines tested, well known plugins, templates
and helper scripts to provide a rapid development environment.

%prep
%setup -q -n CGI-Application-Structured-Tools-%{version}
%patch0

cat << \EOF > %{name}-req
#!/bin/sh
%{__perl_requires} $* |\
sed -e '/perl(<tmpl_var)/d'
EOF

%global __perl_requires %{_builddir}/CGI-Application-Structured-Tools-%{version}/%{name}-req
chmod +x %{__perl_requires}

cd lib/CGI/Application/Structured/Tools/templates
for i in create_dbic_schema.pl create_controller.pl \
         boilerplate.t perl-critic.t pod.t pod-coverage.t \
         test-app.t 00-signature.t 01-load.t; do
    chmod 755 $i;
    sed -i 's#!perl#!\/usr\/bin\/perl#' $i;
done

# These are not executables
chmod 644 index.tmpl config-dev.pl

# This is a perl script
sed -i -e '1i#!/usr/bin/perl' server.pl

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes README Todo
%doc --no-dereference LICENSE
%{perl_vendor_privlib}/*
%{_mandir}/man1/*
%{_bindir}/cas-starter.pl

%changelog
