%define module_name CGI-Cache
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark/Timer.pm) perl(CGI/Carp.pm) perl(CPAN.pm) perl(Cache/Cache.pm) perl(Error.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Storable.pm) perl(Test/Compile.pm) perl(Test/More.pm) perl(Tie/Restore.pm) perl(UNIVERSAL/require.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.4214
Release: alt1
Summary: Perl extension to help cache output of time-intensive CGI scripts
Group: Development/Perl
License: gpl2
URL: https://github.com/coppit/cgi-cache

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DC/DCOPPIT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is intended to be used in a CGI script that may
benefit from caching its output. Some CGI scripts may take
longer to execute because the data needed in order to construct
the page may not be quickly computed. Such a script may need to
query a remote database, or may rely on data that doesn't arrive
in a timely fashion, or it may just be computationally intensive.
Nonetheless, if you can afford the tradeoff of showing older,
cached data vs. CGI execution time, then this module will perform
that function.

This module was written such that any existing CGI code could benefit
from caching without really changing any of existing CGI code guts.
The CGI script can do just what it has always done, that is, construct
an html page and print it to the output file descriptor, then exit.
What you'll do in order to cache pages is include the module, specify
some cache options and the cache key, and then call start() to begin
caching output.

Internally, the CGI::Cache module ties the output file descriptor (usually
STDOUT) to an internal variable to which all output is saved. When the user
calls stop() (or the END{} block of CGI::Cache is executed during script
shutdown) the contents of the variable are inserted into the cache using the
cache key the user specified earlier with set_key().

Once a page has been cached in this fashion, a subsequent visit to that page
will invoke the start() function again, which will then check for an existing
cache entry for the given key before continuing through the code. If the cache
entry exists, then the cache entry's content is printed to the output
filehandle (usually STDOUT) and a 0 is returned to indicate that cached output
was used.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE CHANGES README TODO
%perl_vendor_privlib/C*

%changelog
