%define module_name CGI-Capture
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(IO/Scalar.pm) perl(Params/Util.pm) perl(Storable.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.15
Release: alt1
Summary: Meticulously thorough capture and replaying of CGI calls
Group: Development/Perl
License: perl
URL: https://github.com/karenetheridge/CGI-Capture

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETHER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the CGI manpage does a terribly bad job of saving CGI calls. `CGI::Capture' tries
to resolve this and save a CGI call in as much painstaking detail as it
possibly can.

Because of this, `CGI::Capture' should work with server logins, cookies,
file uploads, strange execution environments, special environment
variables, the works.

It does this by capturing a large amount of the perl environment
BEFORE CGI.pm itself gets a chance to look at it, and then restores
it in the same way.

So in essence, it grabs all of `STDIN', `%%ENV', `@INC', and anything
else it can think of. The things it can't replicate, it records anyway
so that later in the debugger it can ensure that the execution
environment is as close as possible to what it captured (and bitch at
you about anything you are doing wrong).

This is a huge help when resolving problems such as when a bug won't
appear because you aren't debugging the script as the web user and in
the same directory.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE README CONTRIBUTING Changes
%perl_vendor_privlib/C*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
