%define module_name CGI-Easy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/UUID.pm) perl(Export/Attrs.pm) perl(MIME/Base64.pm) perl(Module/Build/Tiny.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.0.1
Release: alt1
Summary: simple and straightforward helpers to make CGI easy
Group: Development/Perl
License: mit
URL: https://github.com/powerman/perl-CGI-Easy

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POWERMAN/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This documentation is an overview of CGI::Easy::* modules. For detailed
information about corner cases and available features you should consult
corresponding module documentation: the CGI::Easy::Request manpage,
the CGI::Easy::Headers manpage, the CGI::Easy::Session manpage. If you wanna work with
CGI/HTTP on lower level, you can look at the CGI::Easy::Util manpage.  There also
some other useful modules available separately: the CGI::Easy::URLconf manpage,
the CGI::Easy::SendFile manpage.

CGI::Easy designed to help you do what you want with CGI/HTTP without
forcing you to learn *one more* huge and complex API specific to some
module, or limiting you to do your tasks *only in way* provided by this
module. With CGI::Easy you got all you need in simple hashes, and
you're free to do anything you like with this data, because it's 
your data.

CGI::Easy consist of three main parts:

=over

=item CGI::Easy::Request object

This object actually is simple hash populated with all data related to
current CGI request - GET/POST parameters, cookies, url path, .eI When you
create this object with new(), current request will be parsed (from ` %%ENV '
and ` STDIN '), all useful things will be stored in that object/hash, and
now you're free to do anything you want with this object/hash - modify it
contents in any way, etc. You don't need special methods to access trivial
data like some GET parameter or cookie anymore.

Here is list of keys in that hash prepared for you:

    # -- URL info
    scheme       'http' OR 'https'
    host         'example.com'
    port         80
    path         '/' OR '/index.php' OR '/articles/2008/'
    # -- CGI parameters
    GET          { name => 'powerman', 'color[]' => ['red','green'], .eI }
    POST         { name => 'powerman', avatar => '.eIbinary image data.eI', .eI }
    filename     { name => undef, avatar => 'C:\\Documents\\avatar.png', .eI }
    mimetype     { name => undef, avatar => 'image/png', .eI }
    cookie       { somevar => 'someval', .eI }
    # -- USER details
    REMOTE_ADDR  192.168.2.1
    REMOTE_PORT  12345
    AUTH_TYPE    Basic
    REMOTE_USER  'powerman'
    REMOTE_PASS  'secret'
    # -- original request data
    ENV          { REQUEST_METHOD => 'POST', .eI }
    STDIN        'name=powerman&color[]=red&color[]=green'
    # -- request parsing status
    error        '' OR 'POST body too large' etc.

=item CGI::Easy::Headers object

This object is also very simple hash - keys are HTTP header names and
values are HTTP header values. When you call new() this hash populated
with few headers (notably `'Status'=>'200 OK'' and
`'Content-Type'=>'text/html; charset=utf-8''), but you're free to
change these keys/headers and add your own headers. When you ready to
output all headers from this object/hash you should call compose() method,
and it will return string with all HTTP headers suitable for sending to
browser.

There one exception: value for key 'Set-Cookie' is ARRAYREF with HASHREFs,
where each HASHREF keep cookie details:

    $h->{'Set-Cookie'} = [
        { name=>'mycookie1', value=>'myvalue1' },
        { name=>'x', value=>5,
          domain=>'.example.com', expires=>time+86400 }
    ];

To make it ease for you to work with this key there helper add_cookie()
method available, but you're free to modify this key manually if you like.

There also some helper methods in this object (like redirect()), but they
all just modify some keys/headers in this hash.

=item CGI::Easy::Session object

This object make working with cookies even more ease than already provided
by CGI::Easy::Request and CGI::Easy::Headers way:

    my $somevalue = $r->{cookie}{somename};
    $h->add_cookie({ name => 'somename', value => $somename });

If you will use CGI::Easy::Session, then it will read/write values for
three cookies: `sid', `perm' and `temp'. Cookie `sid' will contain
automatically generated ID unique to this visitor, cookies `perm' and
`temp' will contain simple perl hashes (automatically serialized to
strings for storing in cookies) with different lifetime: `perm' will
expire in 1 year, `temp' will expire when browser closes.

CGI::Easy::Session object will provide you with three keys:

    id          undef OR '.eIunique string.eI'
    perm        { x=>5, somename=>'somevalue', .eI }
    temp        { y=>7, .eI }

Field `id' will contain undef() in case user has no cookie support.
To serialize hashes in fields `perm' and `temp' to cookies you'll have
to call save() method before `$h->compose()'. Example:

    if (!defined $sess->{id}) {
        warn "user has no cookie support";
    }
    $sess->{perm}{x} = 5;
    $sess->{perm}{somename} = 'somevalue';
    $sess->{temp}{y}++;
    $sess->save();
    print $h->compose();

=back

You don't have to use all these three parts - for example, you can use
only CGI::Easy::Request and output HTTP headers manually, or use only
CGI::Easy::Headers and parse CGI parameters using standard the CGI manpage module,
etc.



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/C*

%changelog
