%define module_name CGI-Easy-URLconf
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Export/Attrs.pm) perl(Module/Build/Tiny.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.0.1
Release: alt1
Summary: map url path to handler sub and vice versa
Group: Development/Perl
License: mit
URL: https://github.com/powerman/perl-CGI-Easy-URLconf

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POWERMAN/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module provide support for clean, user-friendly URLs. This can be
archived by configuring web server to run your CGI/FastCGI script for any
url requested by user, and let you manually dispatch different urls to
corresponding handlers (subroutines). Additionally, you can take some
CGI parameters from url's path instead of usual GET parameters.

 The idea is to set rules when CGI/FastCGI starts using:
   a) setup_path() - to map url's path to handler subroutine
      (also called "view")
   b) setup_view() - to map handler subroutine to url
 and then use:
   a) path2view() - to get handler subroutine matching current url's path
   b) view2path() - to get url matching some handler subroutine
      (for inserting into HTML templates or sending redirects).

Example:

    # -- while CGI/FastCGI initialization
    setup_path(
        '/articles/'        => \&list_articles,
        '/articles.php'     => \&list_articles,
        '/index.php'        => \&show_home_page,
    );
    setup_path( POST =>
        '/articles/'        => \&add_new_article,
    );

    # -- when beginning to handle new CGI/FastCGI request
    my $r = CGI::Easy::Request->new();
    my $handler = path2view($r);
    # $handler now set to:
    #   \&list_articles   if url path /articles/ and request method is GET
    #   \&add_new_article if url path /articles/ and request method is POST
    #   \&list_articles   if url path /articles.php (any request method)
    #   \&show_home_page  if url path /index.php (any request method)
    #   undef             (in all other cases)

    # -- while CGI/FastCGI initialization
    setup_view(
        \&list_articles     => '/articles/',
        # we don't have to configure mapping for \&show_home_page
        # and \&add_new_article because their mappings can be
        # unambiguously automatically detected from above setup_path()
    );

    # -- when preparing reply (HTML escaping omitted for simplicity)
    printf '<a href="%%s">Articles</a>', view2path(\&list_articles);
    printf '<form method=POST action="%%s">', view2path(\&add_new_article);
    # -- or redirecting to another url
    my $h = CGI::Easy::Headers->new();
    $h->redirect(view2path(\&show_home_page));

These two parts (setup_path() with path2view() and setup_view() with view2path())
can be used independently - for example, you don't have to use
setup_view() and view2path() if you prefer to hardcode urls in HTML templates
instead of generating them dynamically. But using both parts will let you
configure *all* urls used in your application in single place, which make
it easier to control and modify them.

In addition to simple constant path to handler and vice versa mapping you
can also map any path matching regular expression and even copy some data
from path to GET parameters. Example:

    # make /article/123/ same as /index.php?id=123
    # use same handler for any url beginning with /old/
    setup_path(
        '/article.php'          => \&show_article,
        qr{^/article/(\d+)/$}   => set_param('id') => \&show_article,
        qr{^/old/}              => \&unsupported,
    );

    # generate urls like /article/123/ dynamically
    setup_view(
        \&show_article          => [
            with_params('id')       => '/article/?/',
        ],
    );
    $url = view2path(\&show_article, id=>123);



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/C*

%changelog
