%define module_version 1.0217
%define module_name CGI-IDS
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(CGI/Pretty.pm) perl(Carp.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(HTML/Entities.pm) perl(JSON/XS.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(XML/Parser.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0217
Release: alt1
Summary: PerlIDS - Perl Website Intrusion Detection System (XSS, CSRF, SQLI, LFI etc.)
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/H/HI/HINNERK/PerlIDS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
PerlIDS (CGI::IDS) is a website intrusion detection system based on PHPIDS https://phpids.org/ to detect possible attacks in website requests, e.g. Cross-Site Scripting (XSS), Cross-Site Request Forgery (CSRF), SQL Injections (SQLI) etc.

It parses any hashref for possible attacks, so it does not depend on CGI.pm.

The intrusion detection is based on a set of converters that convert the request according to common techniques that are used to hide attacks. These converted strings are checked for attacks by running a filter set of currently 68 regular expressions and a generic attack detector to find obfuscated attacks. For easily keeping the filter set up-to-date, PerlIDS is compatible to the original XML filter set of PHPIDS, which is frequently updated.

Each matching regular expression has it's own impact value that increases the tested string's total attack impact. Using these total impacts, a threshold can be defined by the calling application to log the suspicious requests to database and send out warnings via e-mail or even SMS on high impacts that indicate critical attack activity. These impacts can be summed per IP address, session or user to identify attackers who are testing the website with small impact attacks over a time.

You can improve the speed and the accurancy (reduce false positives) of the IDS by specifying an XML whitelist file. This whitelist check can also be processed separately by using CGI::IDS::Whitelist if you want to pre-check the parameters on your application servers before you send only the suspicious requests over to worker servers that do the complete CGI::IDS check.

Follow PerlIDS on twitter: https://twitter.com/perlids


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes examples
%perl_vendor_privlib/C*

%changelog
