Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-CGI-Prototype
Version:        0.9054
Release:        alt2_37
Summary:        Create a CGI application by subclassing
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/CGI-Prototype
Source0:        https://cpan.metacpan.org/authors/id/M/ME/MERLYN/CGI-Prototype-%{version}.tar.gz
BuildArch:      noarch

# core
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Test/More.pm)
# cpan
BuildRequires:  perl(base.pm)
BuildRequires:  perl(CGI.pm)
BuildRequires:  perl(Class/Prototyped.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Template.pm)
BuildRequires:  perl(warnings.pm)
# test
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)

# use base masks these...
Requires:       perl(CGI.pm)
Requires:       perl(Template.pm)



Source44: import.info
%filter_from_provides /perl(My./d

%description
The core of every CGI application seems to be roughly the same:

*   Analyze the incoming parameters, cookies, and URLs to determine the state
of the application (let's call this "dispatch").  
* Based on the current state, analyze the incoming parameters to respond to 
any form submitted ("respond").  
*   From there, decide what response page should be generated, and produce it
("render").

CGI::Prototype creates a "Class::Prototyped" engine for doing all this, with 
the right amount of callback hooks to customize the process.  Because I'm 
biased toward Template Toolkit for rendering HTML, I've also integrated that 
as my rendering engine of choice. And, being a fan of clean MVC designs, the
classes become the controllers, and the templates become the views, with clean 
separation of responsibilities, and "CGI::Prototype" a sort of "archetypal" 
controller.


%prep
%setup -q -n CGI-Prototype-%{version}

# make rpmlint happy
perl -pi -e 's|^#! ?perl|#!/usr/bin/perl|' t/*.t t/cprove
chmod -c -x t/cprove

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}

# %{_fixperms} %{buildroot}/*

%check
# note the "skipped: CGI::Prototype::Mecha not found" is expected; this module
# is a runtime requirement of that module, resulting in a
# plugin-before-the-base-module sorta deal.
make test

%files
%doc Changes README TODO t/
%{perl_vendor_privlib}/*

%changelog
