%define module_name CGI-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cpanel/JSON/XS.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(IO/Handle.pm) perl(JSON/PP.pm) perl(MIME/Base64.pm) perl(Sys/Hostname.pm) perl(Test/More.pm) perl(Time/Local.pm) perl(Unicode/UTF8.pm) perl(constant.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.003
Release: alt1
Summary: Common Gateway Interface, with no frills
Group: Development/Perl
License: artistic_2
URL: https://github.com/Grinnz/CGI-Tiny

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
CGI::Tiny provides a modern interface to write
CGI scripts to
dynamically respond to HTTP requests. It is intended to be:

=over

=item * Minimal

CGI::Tiny contains a small amount of code and (on modern Perls) no non-core
requirements. No framework needed.

=item * Simple

CGI::Tiny is straightforward to use, avoids anything magical or surprising, and
provides easy access to the most commonly needed features.

=item * Robust

CGI::Tiny's interface is designed to help the developer avoid common pitfalls
and vulnerabilities by default.

=item * Lazy

CGI::Tiny only loads code or processes information once it is needed, so simple
requests can be handled without unnecessary overhead.

=item * Restrained

CGI::Tiny is designed for the CGI protocol which executes the program again for
every request. It is not suitable for persistent protocols like FastCGI or
PSGI.

=item * Flexible

CGI::Tiny can be used with other modules to handle tasks like routing and
templating, and doesn't impose unnecessary constraints to reading input or
rendering output.

=back

See the section on "COMPARISON TO CGI.PM".

This module's interface is currently *EXPERIMENTAL* and may be changed
incompatibly if needed.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes CONTRIBUTING.md examples
%perl_vendor_privlib/C*

%changelog
