# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPANPLUS.pm) perl(CPANPLUS/Backend.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(Module/Build.pm) perl(Module/CoreList.pm) perl(Test.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(YAML.pm) perl(Package/Constants.pm) perl(Archive/Extract.pm) perl(File/Fetch.pm)
# END SourceDeps(oneline)
%define module_version 0.16
%define module_name CPAN-Dependency
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: Analyzes CPAN modules and generates their dependency tree
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SAPER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
*Please note that this module is no longer maintained.
Check the section on "See ALSO" for similar, more recent modules.*

This module can process a set of distributions, up to the whole CPAN, 
and extract the dependency relations between these distributions. 
Alternatively, it can load the prerequisites information from a 
CPANTS database. 

It also calculates a score for each distribution based on the number 
of times it appears in the prerequisites of other distributions. 
The algorithm is described in more details in the section on "SCORE CALCULATION". 

`CPAN::Dependency' stores the data in an internal structure which can 
be saved and loaded using `save_deps_tree()' and `load_deps_tree()'. 
The structure looks like this: 

    DEPS_TREE = {
        DIST => {
            author => STRING, 
            cpanid => STRING, 
            score  => NUMBER, 
            prereqs => {
                DIST => BOOLEAN, 
                ...
            }, 
            used_by => {
                DIST => BOOLEAN, 
                ...
            }, 
        }, 
        ....
    }

With each distribution name *DIST* are associated the following fields: 

=over 4

=item *

`author' is a string which contains the name of the author who wrote 
(or last released) this distribution; 

=item *

`cpanid' is a string which contains the CPAN ID of the author who wrote 
(or last released) this distribution;

=item *

`score' is a number which represents the score of the distribution; 

=item *

`prereqs' is a hashref which represents the prerequisites of the distribution;
each key is a prerequisite name and its value is a boolean which is true when 
the distribution and the prerequisite are not from the same author; 

=item *

`used_by' is a hashref which represents the distributions which use this 
particular distribution; each key is a distribution name and its value is a 
boolean which is true when both distributions are not from the same author; 

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README LICENSE.Artistic LICENSE.GPL Changes
%perl_vendor_privlib/C*

%changelog
