%define module_name CPAN-Plugin-Sysdeps
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(CPAN/Distribution.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.80
Release: alt1
Summary: CPAN.pm plugin for installing external dependencies
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SR/SREZIC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
CPAN::Plugin::Sysdeps is a plugin for CPAN.pm (version >=
2.07) to install non-CPAN dependencies automatically. Currently, the
list of required system dependencies is maintained in a static data
structure in the CPAN::Plugin::Sysdeps::Mapping manpage. Supported operations
systems and distributions are FreeBSD and Debian-like Linux
distributions. There are also some module rules for Fedora-like Linux
distributions, Windows through chocolatey, and Mac OS X through
homebrew.

The plugin may be configured like this:

    o conf plugin_list CPAN::Plugin::Sysdeps=arg1,arg2,...

Possible arguments are:

=over

=item `apt-get', `aptitude', `pkg', `yum', `homebrew'

Force a particular installer for system packages. If not set, then the
plugin find a default for the current operating system or linux
distributions:

=over

=item Debian-like distributions: `apt-get'

=item Fedora-like distributions: `yum'

=item FreeBSD: `pkg'

=item Windows: `chocolatey'

=item Mac OS X: `homebrew'

=back

Additionally, the sudo(1) manpage is prepended before the installer programm if
the current user is not a privileged one, and the installer requires
elevated privileges.

=item `batch'

Don't ask any questions.

=item `interactive'

Be interactive, especially ask for confirmation before installing a
system package.

=item `dryrun'

Only log installation actions.

=item `debug'

Turn debugging on. Alternatively the environment variable
`CPAN_PLUGIN_SYSDEPS_DEBUG' may be set to a true value.

=item `mapping=*perlmod|file*'

Prepend another static mapping from cpan modules or distributions to
system packages. This should be specified as a perl module
(*Foo::Bar*) or an absolute file name. The mapping file is supposed
to just return the mapping data structure as described below.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/C*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
