# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(DBI.pm) perl(Encode.pm) perl(Test/CPAN/Meta.pm) perl(Test/CPAN/Meta/JSON.pm) perl(Test/EOL.pm) perl(Test/Fixme.pm) perl(Test/Kwalitee.pm) perl(Test/MinimumVersion.pm) perl(Test/NoTabs.pm) perl(Test/PAUSE/Permissions.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    CPAN-SQLite
%define upstream_version 0.220

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Maintain and search a minimal CPAN database
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/CPAN/%{upstream_name}-%{upstream_version}.tar.gz
# (tv) fix tests w/o networking (CPAN RT#117853):
Patch0:     fix-tests-wo-networking.patch

BuildRequires: perl(Archive/Tar.pm)
BuildRequires: perl(CPAN/DistnameInfo.pm)
BuildRequires: perl(CPAN/Index.pm)
BuildRequires: perl(Compress/Zlib.pm)
BuildRequires: perl(DBD/SQLite.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/HomeDir.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(HTTP/Tiny.pm)
BuildRequires: perl(IO/Zlib.pm)
BuildRequires: perl(parent.pm)
BuildArch:  noarch
Source44: import.info

%description
This package is used for setting up, maintaining, and searching a CPAN
database consisting of the information stored in the three main CPAN
indices: _$CPAN/modules/03modlist.data.gz_,
_$CPAN/modules/02packages.details.txt.gz_, and
_$CPAN/authors/01mailrc.txt.gz_. It should be considered at an alpha stage
of development.

One begins by creating the object as

  my $obj = CPAN::SQLite->new(%%args);

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
%patch0 -p1


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%{make_build}

%check
rm -f t/05meta_new.t t/05meta_update.t t/06retrieve.t
make test

%install
%makeinstall_std

%files
%doc Changes INSTALL LICENSE META.json META.yml  README
%{_bindir}/*
%{_mandir}/man1/*
%{perl_vendor_privlib}/*

%changelog
