%define module_name CWB-CQI
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.5.0
Release: alt1
Summary: IMS Open Corpus Workbench: CQi reference implementation Version 3.0.0
Group: Development/Perl
License: perl
URL: https://cwb.sourceforge.io/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SC/SCHTEPF/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
  compatible with CQi version 0.1 / CWB version 3.0+


This package contains a reference implementation of the CQi client-server
protocol for the Perl programming language.  In addition to a client API
library and a CQPserver launcher, several example scripts illustrating usage
of the CQi interface are included.


PREREQUISITES

As a CQi client library that connects to a remote corpus server, this package
works with any recent Perl distribution and does not require a copy of the
IMS Open Corpus Workbench to be available.  The CQPserver launcher can only
be used if the "cqpserver" program and the basic CWB/Perl package have been
installed.


QUICK INSTALLATION GUIDE

If you have never installed a Perl module before: don't despair.  All you
have to do is to execute the following commands:

    perl Makefile.PL
    make
    make test
    make install

You will probably have to login as root for the last step (or you can type
"sudo make install" and enter your root password).  If you want to install
the CWB/Perl modules in a non-standard location, say in "~/perl/lib/perl5/..."
and "~/perl/man/...", type the following instead of "perl Makefile.PL":

    perl Makefile.PL PREFIX=~/perl INSTALLMAN1DIR=~/perl/man/man1

Note that you will then have to include the appropriate subdirectories of
"~/perl/lib/perl5/" in your Perl search path in order to use the CWB modules.


PACKAGE OVERVIEW

The CQi reference implementation of the following Perl modules

    CWB::CQI            specification of the CQi protocol (command bytecodes)
    CWB::CQI::Client    CQi client library
    CWB::CQI::IOClient  alternative version using IO::Socket interface
    CWB::CQI::CQPserver launcher for local CQPserver (if installed)

See the manual pages (e.g. "perldoc CWB::CQI::Client") of these modules for
further information.  The package also contains a number of example scripts
in the directory "examples/".  If the IMS Open Corpus Workbench and the basic
CWB/Perl interface are installed, these examples will automatically launch
CQPserver on the local machine.  Otherwise, you have to start CQPserver manually
on a remote corpus server and specify the connection details when running 
each example script.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/C*

%changelog
