# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/Size.pm) perl(File/Path.pm) perl(File/Policy.pm) perl(File/Spec/Functions.pm) perl(FileHandle.pm) perl(Log/Trace.pm) perl(Storable.pm) perl(Test/Assertions.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.016
%define module_name Cache-AgainstFile
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.016
Release: alt1
Summary: Cache data structures parsed from files, watching for updates to the file
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BB/BBC/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
A module that caches a data structure against a filename, statting the file to
determine whether it has changed and needs to be re-parsed.  You supply a routine
to generate the data structure given the filename.

This module is recommended for files which change infrequently but are read often, especially if they are expensive to parse.
Example uses include caching precompiled templates, pre-parsed XML or data files on webservers.

This approach has the advantage over lazy caching (where cache items are not validated for a period of time)
that multiple processes (e.g. modperl daemons) holding a cache will all update at the same time so you will
not get inconsistent results if you request data from different processes.

The module itself is simply a factory for various backend modules (each exposing the same API).
The distribution includes backends for in-memory caching or file caching using Storable, plus
an adaptor to use any modules offering the Cache or Cache::Cache interfaces as the cache implementation.

Data structures are automatically serialised/deserialised by the backend modules
if they are being persisted somewhere other than in memory (e.g. on the filesystem).


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING Changes README
%perl_vendor_privlib/C*

%changelog
